/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EffectsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityFlagsRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EquipmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.PlayerDataRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.registries.ForgeRegistries;

public record EntityRequirement(Optional<EntityType<?>> type, Optional<TagKey<EntityType<?>>> tag, Optional<LocationRequirement> location, Optional<LocationRequirement> steppingOn, Optional<EffectsRequirement> effects, Optional<NbtRequirement> nbt, Optional<EntityFlagsRequirement> flags, Optional<EquipmentRequirement> equipment, Optional<PlayerDataRequirement> playerData, Optional<EntityRequirement> vehicle, Optional<EntityRequirement> passenger, Optional<EntityRequirement> target) {
    public static EntityRequirement NONE = new EntityRequirement(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static Codec<EntityRequirement> SIMPLE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().optionalFieldOf("type").forGetter(requirement -> requirement.type), (App)TagKey.m_203877_((ResourceKey)Registry.f_122903_).optionalFieldOf("tag").forGetter(requirement -> requirement.tag), (App)LocationRequirement.CODEC.optionalFieldOf("location").forGetter(requirement -> requirement.location), (App)LocationRequirement.CODEC.optionalFieldOf("stepping_on").forGetter(requirement -> requirement.steppingOn), (App)EffectsRequirement.CODEC.optionalFieldOf("effects").forGetter(requirement -> requirement.effects), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(requirement -> requirement.nbt), (App)EntityFlagsRequirement.CODEC.optionalFieldOf("flags").forGetter(requirement -> requirement.flags), (App)EquipmentRequirement.CODEC.optionalFieldOf("equipment").forGetter(requirement -> requirement.equipment)).apply((Applicative)instance, (type, tag, location, standingOn, effects, nbt, flags, equipment) -> new EntityRequirement((Optional<EntityType<?>>)type, (Optional<TagKey<EntityType<?>>>)tag, (Optional<LocationRequirement>)location, (Optional<LocationRequirement>)standingOn, (Optional<EffectsRequirement>)effects, (Optional<NbtRequirement>)nbt, (Optional<EntityFlagsRequirement>)flags, (Optional<EquipmentRequirement>)equipment, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())));
    private static final List<Codec<EntityRequirement>> REQUIREMENT_CODEC_STACK = new ArrayList<Codec<EntityRequirement>>(List.of(SIMPLE_CODEC));

    public static Codec<EntityRequirement> getCodec() {
        return REQUIREMENT_CODEC_STACK.get(REQUIREMENT_CODEC_STACK.size() - 1);
    }

    private static void addCodecStack() {
        Codec<EntityRequirement> latestCodec = REQUIREMENT_CODEC_STACK.get(REQUIREMENT_CODEC_STACK.size() - 1);
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().optionalFieldOf("type").forGetter(requirement -> requirement.type), (App)TagKey.m_203877_((ResourceKey)Registry.f_122903_).optionalFieldOf("tag").forGetter(requirement -> requirement.tag), (App)LocationRequirement.CODEC.optionalFieldOf("location").forGetter(requirement -> requirement.location), (App)LocationRequirement.CODEC.optionalFieldOf("stepping_on").forGetter(requirement -> requirement.steppingOn), (App)EffectsRequirement.CODEC.optionalFieldOf("effects").forGetter(requirement -> requirement.effects), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(requirement -> requirement.nbt), (App)EntityFlagsRequirement.CODEC.optionalFieldOf("flags").forGetter(requirement -> requirement.flags), (App)EquipmentRequirement.CODEC.optionalFieldOf("equipment").forGetter(requirement -> requirement.equipment), (App)PlayerDataRequirement.getCodec(latestCodec).optionalFieldOf("player_data").forGetter(requirement -> requirement.playerData), (App)latestCodec.optionalFieldOf("vehicle").forGetter(requirement -> requirement.vehicle), (App)latestCodec.optionalFieldOf("passenger").forGetter(requirement -> requirement.passenger), (App)latestCodec.optionalFieldOf("target").forGetter(requirement -> requirement.target)).apply((Applicative)instance, EntityRequirement::new));
        REQUIREMENT_CODEC_STACK.add((Codec<EntityRequirement>)codec);
    }

    public boolean test(Entity entity) {
        if (entity == null) {
            return true;
        }
        if (Objects.equals(this, NONE)) {
            return true;
        }
        if (this.type.isPresent() && !this.type.get().equals((Object)entity.m_6095_())) {
            return false;
        }
        if (this.tag.isPresent() && !entity.m_6095_().m_204039_(this.tag.get())) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().test(entity.f_19853_, entity.m_20182_())) {
            return false;
        }
        if (this.steppingOn.isPresent() && !this.steppingOn.get().test(entity.f_19853_, entity.m_20182_().m_82520_(0.0, -0.5, 0.0))) {
            return false;
        }
        if (this.effects.isPresent() && !this.effects.get().test(entity)) {
            return false;
        }
        if (this.nbt.isPresent() && !this.nbt.get().test(entity)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().test(entity)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().test(entity)) {
            return false;
        }
        if (this.playerData.isPresent() && !this.playerData.get().test(entity)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().test(entity.m_20202_())) {
            return false;
        }
        if (this.passenger.isPresent() && !this.passenger.get().test(entity.m_20197_().isEmpty() ? null : (Entity)entity.m_20197_().get(0))) {
            return false;
        }
        if (this.target.isPresent()) {
            if (!(entity instanceof Monster)) {
                return false;
            }
            Monster monster = (Monster)entity;
            if (!this.target.get().test((Entity)monster.m_5448_())) {
                return false;
            }
        }
        return true;
    }

    public CompoundTag serialize() {
        return (CompoundTag)EntityRequirement.getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElseGet(CompoundTag::new);
    }

    public static EntityRequirement deserialize(CompoundTag tag) {
        return (EntityRequirement)((Pair)EntityRequirement.getCodec().decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow(() -> new IllegalArgumentException("Could not deserialize EntityRequirement"))).getFirst();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityRequirement that = (EntityRequirement)obj;
        return this.type.equals(that.type) && this.location.equals(that.location) && this.steppingOn.equals(that.steppingOn) && this.effects.equals(that.effects) && this.nbt.equals(that.nbt) && this.flags.equals(that.flags) && this.equipment.equals(that.equipment) && this.playerData.equals(that.playerData) && this.vehicle.equals(that.vehicle) && this.passenger.equals(that.passenger) && this.target.equals(that.target);
    }

    @Override
    public String toString() {
        return EntityRequirement.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    static {
        for (int i = 0; i < 16; ++i) {
            EntityRequirement.addCodecStack();
        }
    }
}

